// this is a two-dimensional array that contains our data.
// data is Rank, Peak, Title, Worldwide gross, Year
var films = [
  [1, 1, "Avengers: Endgame", 2797800564, 2019, 8.4, 181, "PG-13", "Action, Adventure, Drama"],
  [2, 1, "Avatar", 2790439000, 2009, 7.8, 162, "PG-13", "Action, Adventure, Fantasy"],
  [3, 1, "Titanic", 2194439542, 1997, 7.8, 194, "PG-13", "Drama, Romance"],
  [4, 3, "Star Wars: The Force Awakens", 2068223624, 2015, 7.9, 138, "PG-13", "Action, Adventure, Sci-Fi"],
  [5, 4, "Avengers: Infinity War", 2048359754, 2018, 8.4, 149, "PG-13", "Action, Adventure, Sci-Fi"],
  [6, 3, "Jurassic World", 1671713208, 2015, 7, 124, "PG-13", "Action, Adventure, Sci-Fi"],
  [7, 7, "The Lion King", 1656943394, 2019, 6.9, 118, "PG", "Animation, Adventure, Drama"],
  [8, 3, "The Avengers", 1518812988, 2012, 8, 143, "PG-13", "Action, Adventure, Sci-Fi"],
  [9, 4, "Furious 7", 1516045911, 2015, 7.1, 137, "PG-13", "Action, Adventure, Thriller"],
  [10, 10, "Frozen II", 1450026933, 2019, 6.9, 103, "PG", "Animation, Adventure, Comedy"],
  [11, 5, "Avengers: Age of Ultron", 1402805868, 2015, 7.3, 141, "PG-13", "Action, Adventure, Sci-Fi"],
  [12, 9, "Black Panther", 1347280838, 2018, 7.3, 134, "PG-13", "Action, Adventure, Sci-Fi"],
  [13, 3, "Harry Potter and the Deathly Hallows - Part 2", 1342025430, 2011, 8.1, 130, "PG-13", "Adventure, Drama, Fantasy"],
  [14, 9, "Star Wars: The Last Jedi", 1332539889, 2017, 7, 152, "PG-13", "Action, Adventure, Fantasy"],
  [15, 12, "Jurassic World: Fallen Kingdom", 1309484461, 2018, 6.2, 128, "PG-13", "Action, Adventure, Sci-Fi"],
  [16, 5, "Frozen", 1290000000, 2013, 7.4, 102, "PG", "Animation, Adventure, Comedy"],
  [17, 10, "Beauty and the Beast", 1263521126, 2017, 7.1, 129, "PG", "Family, Fantasy, Musical"],
  [18, 15, "Incredibles 2", 1242805359, 2018, 7.6, 118, "PG", "Animation, Action, Adventure"],
  [19, 11, "The Fate of the Furious", 1238764765, 2017, 6.7, 136, "PG-13", "Action, Adventure, Crime"],
  [20, 5, "Iron Man 3", 1214811252, 2013, 7.2, 130, "PG-13", "Action, Adventure, Sci-Fi"],
  [21, 10, "Minions", 1159398397, 2015, 6.4, 91, "PG", "Animation, Adventure, Comedy"],
  [22, 12, "Captain America: Civil War", 1153329473, 2016, 7.8, 147, "PG-13", "Action, Adventure, Sci-Fi"],
  [23, 20, "Aquaman", 1148485886, 2018, 6.9, 143, "PG-13", "Action, Adventure, Fantasy"],
  [24, 2, "The Lord of the Rings: The Return of the King", 1142219401, 2003, 8.9, 201, "PG-13", "Action, Adventure, Drama"],
  [25, 24, "Spider-Man: Far From Home", 1131927996, 2019, 7.5, 129, "PG-13", "Action, Adventure, Sci-Fi"],
  [26, 23, "Captain Marvel", 1128274794, 2019, 6.9, 123, "PG-13", "Action, Adventure, Sci-Fi"],
  [27, 5, "Transformers: Dark of the Moon", 1123794079, 2011, 6.2, 154, "PG-13", "Action, Adventure, Sci-Fi"],
  [28, 7, "Skyfall", 1108561013, 2012, 7.7, 143, "PG-13", "Action, Adventure, Thriller"],
  [29, 10, "Transformers: Age of Extinction", 1104054072, 2014, 5.6, 165, "PG-13", "Action, Adventure, Sci-Fi"],
  [30, 7, "The Dark Knight Rises", 1084939099, 2012, 8.4, 164, "PG-13", "Action, Adventure"],
  [31, 31, "Joker", 1074251311, 2019, 8.5, 122, "R", "Crime, Drama, Thriller"],
  [32, 32, "Star Wars: The Rise of Skywalker", 1074144248, 2019, 6.6, 141, "PG-13", "Action, Adventure, Fantasy"],
  [33, 30, "Toy Story 4", 1073394593, 2019, 7.8, 100, "G", "Animation, Adventure, Comedy"],
  [34, 4, "Toy Story 3", 1066969703, 2010, 8.3, 103, "G", "Animation, Adventure, Comedy"],
  [35, 3, "Pirates of the Caribbean: Dead Man's Chest", 1066179725, 2006, 7.3, 151, "PG-13", "Action, Adventure, Fantasy"],
  [36, 20, "Rogue One: A Star Wars Story", 1056057273, 2016, 7.8, 133, "PG-13", "Action, Adventure, Sci-Fi"],
  [37, 34, "Aladdin", 1050693953, 2019, 7, 128, "PG", "Adventure, Family, Fantasy"],
  [38, 6, "Pirates of the Caribbean: On Stranger Tides", 1045713802, 2011, 6.6, 136, "PG-13", "Action, Adventure, Fantasy"],
  [39, 24, "Despicable Me 3", 1034799409, 2017, 7.6, 95, "PG", "Animation, Comedy, Family"],
  [40, 1, "Jurassic Park", 1029939903, 1993, 8.1, 127, "PG-13", "Action, Adventure, Sci-Fi"],
  [41, 22, "Finding Dory", 1028570889, 2016, 7.3, 97, "PG", "Animation, Adventure, Comedy"],
  [42, 2, "Star Wars: Episode I - The Phantom Menace", 1027044677, 1999, 6.5, 136, "PG", "Action, Adventure, Fantasy"],
  [43, 5, "Alice in Wonderland", 1025467110, 2010, 6.4, 108, "PG", "Adventure, Family, Fantasy"],
  [44, 24, "Zootopia", 1023784195, 2016, 8, 108, "PG", "Animation, Adventure, Comedy"],
  [45, 14, "The Hobbit: An Unexpected Journey", 1021103568, 2012, 7.8, 169, "PG-13", "Adventure, Fantasy"],
  [46, 2, "Harry Potter and the Philosopher's Stone", 1006536662, 2001, 7.6, 152, "PG", "Adventure, Family, Fantasy"],
  [47, 4, "The Dark Knight", 1004934033, 2008, 9, 152, "PG-13", "Action, Crime, Drama"],
  [48, 10, "Harry Potter and the Deathly Hallows - Part 1", 976941486, 2010, 7.7, 146, "PG-13", "Adventure, Family, Fantasy"],
  [49, 19, "Despicable Me 2", 970761885, 2013, 7.3, 98, "PG", "Animation, Adventure, Comedy"],
  [50, 2, "The Lion King", 968483777, 1994, 7.3, 88, "G", "Animation, Adventure, Drama"]
];

// we will scale the bar heights based on the highest grossing movie.
var highest = 0;
var scale;
var barw = 19;
var maxHeight = 400;
var increment = 250000000;

// setup is automatically called once when the page loads.
function setup(){

  // createCanvas() creates the canvas element we will be drawing to.
  var canvas = createCanvas(1100, 700);
  canvas.parent("sketch");

  // cycle through the table
  for (var r=0; r<films.length; r++){
    var row = films[r];
    if(row[3] > highest){
      highest = row[3];
    }
  }

  scale = maxHeight / highest;
  noLoop();
  textSize(10);

}

// draw is automatically called 60 times a second (unless noLoop() is called in setup()).
function draw(){

  // variables hold the current position and bar height.
  var xpos = 30;
  var ypos = 450;
  var barh = 0;

  // draw the chart behind our data
  for(var i=0; i<highest; i += increment){
    // define visual styles for the chart legend
    stroke(220);
    fill(128);
    var bary = ypos - (i*scale);
    line(xpos - barw, bary, width - xpos + barw, bary);
    // value is in millions of dollars
    var value = "$" + (i / 1000000) + " m";
    noStroke();
    text(value, width - 50, bary - 2);
  }

  // for each film entry in our data...
  for (var r=0; r<films.length; r++){
    var row = films[r];
    barh = scale * row[3];

    // define the visual styles for the bars
    noStroke();
    fill(128, 192);

    // draw the bar using the defined width, height, and position.
    rect(xpos, ypos-barh, barw, barh);

    // draw the title of the movie, but rotate it 45 degrees.
    fill(0);
    push();
    translate(xpos + 4, ypos + 10);
    rotate(PI/4);
    text(row[2], 0, 0);
    pop();

    // move our next bar over slightly.
    xpos += barw + 1;
  }

  // draw labels
  textAlign(CENTER);
  textSize(14);
  noStroke();
  text("Top 50 Highest Grossing Films", width/2, 30);


}
